varying vec2 f_texcoord;
varying vec4 f_colorLightAmbient;
varying vec4 f_colorLightNonAmbient;

uniform sampler2D texture1;

#ifdef MULTI_TEX
uniform sampler2D texture2;
varying float f_factor1;
#endif

#ifdef MULTI_TEX2
uniform sampler2D texture3;
varying float f_factor2;
#endif

#ifdef MULTI_TEX3
uniform sampler2D texture4;
varying float f_factor3;
#endif

#ifdef FOG
varying float f_fogFactor;
varying float f_fogFactorGround;
#endif

#ifdef SHADOW
	uniform int shadow_csm_index;
	uniform sampler2DShadow texture_shadow_close;
	uniform sampler2DShadow texture_shadow_far;
	varying vec4 f_shadow_coord;

	#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
	varying vec4 f_shadow_coord_far;
	varying vec3 coord_world;
	uniform vec3 shadow_close_center;
	#endif

	#ifdef SHADOW_SLOPE_BIAS
	varying float f_shadow_slope_bias;
	#endif
#endif


void main(void)
{
	vec4 colorResult = texture2D(texture1, f_texcoord);

#ifdef MULTI_TEX
	vec4 colorTex2 = texture2D(texture2, f_texcoord);
	colorResult = mix(colorResult, colorTex2, f_factor1);
#endif

#ifdef MULTI_TEX2
	vec4 colorTex3 = texture2D(texture3, f_texcoord);
	colorResult = mix(colorResult, colorTex3, f_factor2);
#endif

#ifdef MULTI_TEX3
	vec4 colorTex4 = texture2D(texture4, f_texcoord);
	colorResult = mix(colorResult, colorTex4, f_factor3);
#endif

	vec4 colorLightNonAmbient = f_colorLightNonAmbient;
#ifdef SHADOW
	#ifdef SHADOW_SLOPE_BIAS
	float shadow_slope_bias = f_shadow_slope_bias;
	#else
	float shadow_slope_bias = SHADOW_SLOPE_BIAS_CONST;
	#endif

	#ifndef SHADOW_MAP_CORRESPONDS_SUBDIVS
	float visibility = getVisibility(shadow_csm_index, texture_shadow_close, texture_shadow_far, f_shadow_coord, f_shadow_coord_far, shadow_slope_bias, shadow_close_center, coord_world);
	#else
	float visibility = getVisibility(shadow_csm_index, texture_shadow_close, texture_shadow_far, f_shadow_coord, shadow_slope_bias);
	#endif

	colorLightNonAmbient *= getVisibilityVector(visibility);
#endif

	//Result
	colorResult = (colorLightNonAmbient + f_colorLightAmbient) * colorResult;

#ifdef FOG
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR, f_fogFactor);
	colorResult.rgb = mix(colorResult.rgb, FOG_COLOR_GROUND, f_fogFactorGround);
#endif

	gl_FragColor = colorResult;
}

